/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.sa;

import com.ibm.hwmca.base.pa.problem.ProblemNumberFilter;
import com.ibm.hwmca.base.rsf.requests.SdrAdditionalData;
import com.ibm.hwmca.base.rsf.requests.SdrHttpRequest;
import com.ibm.hwmca.base.rsf.requests.SdrRequestBody;
import com.ibm.hwmca.base.rsf.sas.CredentialResult;
import com.ibm.hwmca.base.rsf.sas.CredentialStore;
import com.ibm.hwmca.base.rsf.sas.CredentialUtils;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HwmcaParser;
import com.ibm.hwmca.fw.eventmon.email.Emailer;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogClass;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.rcs.sas.SysInfo;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.util.ByteArray;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.remsrv.RemoteServiceManager;
import com.ibm.hwmca.p.rsf.PICredentials;
import com.ibm.hwmca.p.sa.CustomerNotifyPersistable;
import com.ibm.hwmca.p.sa.FtpFirewallPersistable;
import com.ibm.hwmca.p.sa.FtpOffLoadPersistable;
import com.ibm.hwmca.p.sa.ServiceAgentAttr;
import com.ibm.hwmca.p.sa.XMITServiceInfoPersistable;
import com.ibm.hwmca.xfw.rsf.RsfMachineInfo;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceAgentUtils
implements SdrAdditionalData,
ServiceAgentAttr,
LogClass {
    private static final String TRACE_MASKT = "ESA    T";
    private static final String TRACE_MASKF = "ESA    F";
    private static final String TRACE_MASKD = "ESA    D";
    private static final String CLASS_NAME = "[ServiceAgentUtils] ";
    public static final int ESA_RSF_SERVICE_SERVER = 1;
    public static final int ESA_RSF_NOSERVICE_SERVER = 2;
    public static final int ESA_RSF_SERVICE_NOSERVER = 3;
    public static final int ESA_RSF_NOSERVICE_NOSERVER = 4;
    public static final int ESA_RSF_NOT_SUPPORTED = 5;
    public static final String ESAMSG = "com.ibm.hwmca.p.sa.res.ServiceAgent";
    public static final String ESAAGR = "com.ibm.hwmca.p.sa.res.license";
    public static final int ESA_SYNC = 1;
    public static final int ESA_ASYNC = 2;
    private static final String ESA_PATH = "esadirectory";
    private static final String ESA_PMH_DEFAULT = "NOPMH";
    private static final String ESA_PROB_DEFAULT = "NOPROB";
    public static final String ESA_KEY_PRIMARYID = "-PrimaryID";
    public static final String ESA_KEY_OPTIONALID = "-OptionalID";
    public static final String ESA_KEY_SENDINGMACHINEID = "-SendingMachineID";
    public static final String ESA_KEY_SENDINGPASSWORD = "-SendingPassword";
    public static final String ESA_KEY_OWNINGMACHINEID = "-OwningMachineID";
    public static final String ESA_KEY_OWNINGPASSWORD = "-OwningPassword";
    public static final String ESA_KEY_SENDINGCLIENTVERSION = "-SendingClientVersion";
    public static final String ESA_KEY_OWNINGCLIENTVERSION = "-OwningClientVersion";
    public static final String ESA_KEY_EED_FILENAME = "-FileName";
    public static final String ESA_KEY_EED_TIMESTAMP = "-TimeStamp";
    public static final String ESA_KEY_EED_LENGTH = "-Length";
    public static final String ESA_KEY_HCHK_REPORTING_SYSTEM = "-ReportingSystem";
    public static final String ESA_KEY_HCHK_FREQUENCY = "-Frequency";
    public static final String ESA_KEY_HCHK_STATUS = "-Status";
    public static final String ESA_KEY_VPD_NONDELTAREASON = "-NonDeltaReason";
    public static final int ESA_SDR_AUTHORIZE1 = 1;
    private static final String ESA_SDR_AUTHORIZE1_FILE = "ESAAuthorize1.xml";
    public static final int ESA_SDR_AUTHORIZE2 = 2;
    private static final String ESA_SDR_AUTHORIZE2_FILE = "ESAAuthorize2.xml";
    public static final int ESA_SDR_PROBLEMEED = 3;
    public static final int ESA_SDR_DUMPEED = 4;
    public static final int ESA_SDR_ENDOFCALLEED = 5;
    private static final String ESA_SDR_EED_FILE = "ESAEED.xml";
    public static final int ESA_SDR_FULLVPD = 6;
    private static final String ESA_SDR_FULLVPD_FILE = "ESAFullVPD.xml";
    public static final int ESA_SDR_HEALTHCHECK = 7;
    private static final String ESA_SDR_HEALTHCHECK_FILE = "ESAHealthCheck.xml";
    public static final int ESA_SDR_PMDATA = 8;
    private static final String ESA_SDR_PMDATA_FILE = "ESAPMData.xml";
    public static final String ESA_PR_VAL_SUCCESS = "ESA.status.success";
    public static final String ESA_PR_VAL_PENDING = "ESA.status.pending";
    public static final String ESA_PR_VAL_FAILED = "ESA.status.failed";
    public static final String ESA_PR_VAL_PMRSTATUS_OPEN = "ESA.pmrstatus.open";
    public static final String ESA_PR_VAL_PMRSTATUS_CE = "ESA.pmrstatus.ce";
    public static final String ESA_PR_VAL_PMRSTATUS_FIX = "ESA.pmrstatus.fix";
    public static final String ESA_CUSTOMER_NOTIFY_PERSIST = "com.ibm.hwmca.p.sa.persist.CustomerNotify";
    public static final String ESA_FTP_OFFLOAD_PERSIST = "com.ibm.hwmca.p.sa.persist.FtpOffLoad";
    public static final String ESA_FTP_FIREWALL_PERSIST = "com.ibm.hwmca.p.sa.persist.FtpFirewall";
    public static final String ESA_XMIT_SERVICE_INFO_PERSIST = "com.ibm.hwmca.p.sa.persist.XmitServiceInfo";
    public static final String ESA_ALL = "ESA.All";
    public static final String ESA_CALLHOMEONLY = "ESA.CallHomeOnly";
    public static final int ESA_EMAILADDRESS_ALREADY_EXISTS = 1;
    public static final int ESA_EMAILADDRESS_NOT_FOUND = 2;
    public static final int ESA_EMAIL_SEND_ERROR = 3;
    public static final int ESA_CNP_WRITE_EXCEPTION = 1;
    public static final int ESA_CNP_WRITE_NOT_SET = 2;
    public static final int ESA_CNP_READ_NOT_SET = 3;
    public static final int ESA_XMIT_WRITE_EXCEPTION = 4;
    public static final int ESA_XMIT_WRITE_NOT_SET = 5;
    public static final int ESA_XMIT_READ_NOT_SET = 6;
    public static final int ESA_FTP_WRITE_EXCEPTION = 7;
    public static final int ESA_FTP_WRITE_NOT_SET = 8;
    public static final int ESA_FTP_READ_NOT_SET = 9;
    public static final int ESA_FTP_FW_WRITE_EXCEPTION = 10;
    public static final int ESA_FTP_FW_WRITE_NOT_SET = 11;
    public static final int ESA_FTP_FW_READ_NOT_SET = 12;
    private static final String ESA_FTP_FIREWALL_FILE = "firewall";
    private static final String ESA_FTP_FIREWALL_SAVE_FILE = "/root/.ncftp/firewall";
    public static final String ESA_KEY_FtpFirewallType = "-FtpFirewallType";
    public static final String ESA_KEY_FtpFirewallHostName = "-FtpFirewallHostName";
    public static final String ESA_KEY_FtpFirewallUserName = "-FtpFirewallUserName";
    public static final String ESA_KEY_FtpFirewallUserPassword = "-FtpFirewallUserPassword";
    public static final String ESA_KEY_FtpFirewallPort = "-FtpFirewallPort";
    public static final String ESA_KEY_FtpFirewallExclusionList = "-FtpFirewallExclusionList";
    public static final String ESA_KEY_FtpFirewallPassiveMode = "-FtpFirewallPassiveMode";
    static final Comparator PRIORITY_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            Trace.trace(ServiceAgentUtils.TRACE_MASKF, "[ServiceAgentUtils] -> PRIORITY_ORDER");
            int cmp = 0;
            sectionInfo si1 = (sectionInfo)o1;
            sectionInfo si2 = (sectionInfo)o2;
            Trace.trace(ServiceAgentUtils.TRACE_MASKF, "[ServiceAgentUtils] si1.priority: " + si1.priority + " si1.size: " + si1.size);
            Trace.trace(ServiceAgentUtils.TRACE_MASKF, "[ServiceAgentUtils] si2.priority: " + si2.priority + " si2.size: " + si2.size);
            cmp = si1.priority == si2.priority ? 1 : si1.priority - si2.priority;
            return cmp;
        }
    };
    static final Comparator SECTION_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            Trace.trace(ServiceAgentUtils.TRACE_MASKF, "[ServiceAgentUtils] -> SECTION_ORDER");
            int cmp = 0;
            sectionInfo si1 = (sectionInfo)o1;
            sectionInfo si2 = (sectionInfo)o2;
            Trace.trace(ServiceAgentUtils.TRACE_MASKF, "[ServiceAgentUtils] si1.section: " + si1.section);
            Trace.trace(ServiceAgentUtils.TRACE_MASKF, "[ServiceAgentUtils] si2.section: " + si2.section);
            cmp = si1.section <= si2.section ? -1 : 1;
            return cmp;
        }
    };

    public String updateConnectionInfo(String xmlRequest, File dataFile, String sendingMachineId, String sendingPassword, String owningMachineId, String owningPassword, String connectionType, String acctName, String acctUserid) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] updateConnectionInfo");
        String result = xmlRequest;
        Pattern p = Pattern.compile(ESA_KEY_SENDINGMACHINEID);
        Matcher m = p.matcher("");
        m.reset(result);
        result = m.replaceAll(sendingMachineId);
        p = Pattern.compile(ESA_KEY_SENDINGPASSWORD);
        m = p.matcher("");
        m.reset(result);
        result = m.replaceAll(sendingPassword);
        p = Pattern.compile(ESA_KEY_OWNINGMACHINEID);
        m = p.matcher("");
        m.reset(result);
        result = m.replaceAll(owningMachineId);
        p = Pattern.compile(ESA_KEY_OWNINGPASSWORD);
        m = p.matcher("");
        m.reset(result);
        result = m.replaceAll(owningPassword);
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] updated xml[" + result + "]");
        return result;
    }

    public String extractXmlRc(String xmlResponse) {
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] extractXmlRc");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xmlResponse[" + xmlResponse + "]");
        String XmlRc = "0000";
        HashMap map = new HashMap();
        ServiceAgentUtils.processSdrReturn(xmlResponse, map);
        String return_code = (String)map.get("return-code");
        if (return_code != null) {
            XmlRc = return_code;
        }
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] extractXmlRc: " + XmlRc);
        return XmlRc;
    }

    public static void processSdrReturn(String xmlResponse, Map map) {
        block16: {
            try {
                byte[] xml = xmlResponse.getBytes("US-ASCII");
                Document returnXml = new HwmcaParser(xml, false).getDocument();
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] done parsing xmlResponse");
                if (returnXml == null) break block16;
                Element root = returnXml.getDocumentElement();
                if (root.getNodeName().toLowerCase().trim().equals("sessionless-sdr-return-v2")) {
                    NamedNodeMap nnm = root.getAttributes();
                    if (nnm != null) {
                        int i = 0;
                        while (i < nnm.getLength()) {
                            Node val = nnm.item(i);
                            map.put(val.getNodeName().toLowerCase().trim(), val.getNodeValue());
                            Trace.trace(TRACE_MASKF, CLASS_NAME + val.getNodeName().toLowerCase().trim() + " " + val.getNodeValue());
                            ++i;
                        }
                    }
                    NodeList childNodes = root.getChildNodes();
                    int numChildren = childNodes.getLength();
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got " + numChildren + " children to process");
                    int i = 0;
                    while (i < numChildren) {
                        Node child = childNodes.item(i);
                        if (child.getNodeType() == 1) {
                            Node text;
                            NodeList textnodes;
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got ELEMENT_NODE " + child.getNodeName().toLowerCase().trim());
                            if (child.getNodeName().toLowerCase().trim().equals("reason-qualifier")) {
                                textnodes = child.getChildNodes();
                                if (textnodes != null) {
                                    text = textnodes.item(0);
                                    map.put(child.getNodeName().toLowerCase().trim(), text.getNodeValue());
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sdr-return: " + child.getNodeName().toLowerCase().trim() + " " + text.getNodeValue());
                                }
                            } else if (child.getNodeName().toLowerCase().trim().equals("return-text")) {
                                textnodes = child.getChildNodes();
                                if (textnodes != null) {
                                    text = textnodes.item(0);
                                    map.put(child.getNodeName().toLowerCase().trim(), text.getNodeValue());
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sdr-return: " + child.getNodeName().toLowerCase().trim() + " " + text.getNodeValue());
                                }
                            } else if (!(child.getNodeName().toLowerCase().trim().equals("pmr") || child.getNodeName().toLowerCase().trim().equals("download-menu") || child.getNodeName().toLowerCase().trim().equals("download-item") || child.getNodeName().toLowerCase().trim().equals("generic-data") || child.getNodeName().toLowerCase().trim().equals("processing-parm") || child.getNodeName().toLowerCase().trim().equals("enrollment-output") || child.getNodeName().toLowerCase().trim().equals("microcode-download-file") || child.getNodeName().toLowerCase().trim().equals("microcode-customized-list") || child.getNodeName().toLowerCase().trim().equals("microcode-master-list"))) {
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] unknown ELEMENT_NODE: " + child.getNodeName().toLowerCase().trim());
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got a non-element node" + child.getNodeName());
                        }
                        ++i;
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] element not sessionless-sdr-return-v2: " + root.getNodeName());
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got an exception e " + e);
            }
        }
    }

    public static int ESACheckRSF() {
        int rsfSetting = 5;
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESACheckRSF");
        RemoteSupportFacility rsfImpl = RsfManager.getRsfManager().getConsoleRsf();
        rsfSetting = rsfImpl != null ? (rsfImpl.isCallHomeEnabled() && rsfImpl.isCallHomeServerAvailable() ? 1 : (!rsfImpl.isCallHomeEnabled() && rsfImpl.isCallHomeServerAvailable() ? 2 : (rsfImpl.isCallHomeEnabled() && !rsfImpl.isCallHomeServerAvailable() ? 3 : 4))) : 5;
        return rsfSetting;
    }

    public static boolean ESACheckRSF(String machType, String machModel, String machSerial) {
        boolean rsfSetting = false;
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESACheckRSF");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] machType: " + machType);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] machModel: " + machModel);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] machSerial: " + machSerial);
        RemoteSupportFacility rsfImpl = RsfManager.getRsfManager().getConsoleRsf();
        if (rsfImpl != null) {
            RemoteServiceManager rsm = RemoteServiceManager.getRemoteServiceManager();
            if (rsm != null) {
                boolean setting = rsm.isRemoteServiceEnabled(machType, machModel, machSerial);
                if (setting && rsfImpl.isCallHomeServerAvailable()) {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] service is enabled");
                    rsfSetting = true;
                } else {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] isRemoteServiceEnabled: " + setting);
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] isCallHomeServerAvailable: " + setting);
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] rsm was null");
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] rsfImpl was null");
        }
        return rsfSetting;
    }

    private static String ESAProcessXMLRequest(int requestType, Map xmlMap) {
        String XMLfile = "";
        String xmlResults = "";
        Object dataFile = null;
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESAProcessXMLRequest: " + requestType);
        switch (requestType) {
            case 1: {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESA_SDR_AUTHORIZE1");
                XMLfile = ESA_SDR_AUTHORIZE1_FILE;
                break;
            }
            case 2: {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESA_SDR_AUTHORIZE2");
                XMLfile = ESA_SDR_AUTHORIZE2_FILE;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESAEED type=" + requestType);
                XMLfile = ESA_SDR_EED_FILE;
                break;
            }
            case 6: {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESA_SDR_FULLVPD");
                XMLfile = ESA_SDR_FULLVPD_FILE;
                break;
            }
            case 7: {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESA_SDR_HEALTHCHECK");
                XMLfile = ESA_SDR_HEALTHCHECK_FILE;
                break;
            }
            case 8: {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESA_SDR_PMDATA");
                XMLfile = ESA_SDR_PMDATA_FILE;
                break;
            }
            default: {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Invalid requestType....." + requestType);
            }
        }
        try {
            String filePath = BaseFileControl.getFilePath(ESA_PATH);
            File f = new File(filePath + XMLfile);
            FileInputStream fis = new FileInputStream(f);
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            String aLine = null;
            while ((aLine = in.readLine()) != null) {
                xmlResults = xmlResults + aLine.trim();
            }
            in.close();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Error reading xml file: exception e" + e);
        }
        Iterator i = xmlMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xmlMap key[" + e.getKey() + "] value[" + e.getValue() + "]");
            Pattern p = Pattern.compile((String)e.getKey());
            Matcher m = p.matcher("");
            m.reset(xmlResults);
            xmlResults = m.replaceAll((String)e.getValue());
        }
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xml.length()= " + xmlResults.length() + " XML results[" + xmlResults + "]");
        return xmlResults + "\n";
    }

    public static int ESASendAuthorizeRequest(int RequestMode, Map xmlParms) {
        String xmlResults;
        int rc = 0;
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] ESASendAuthorizeRequest");
        int cmd = 1;
        String authorizationID = (String)xmlParms.get(ESA_KEY_PRIMARYID);
        if (xmlParms.containsKey(ESA_KEY_OPTIONALID)) {
            cmd = 2;
            authorizationID = authorizationID + "   " + (String)xmlParms.get(ESA_KEY_OPTIONALID);
        }
        if ((xmlResults = ServiceAgentUtils.ESAProcessXMLRequest(cmd, xmlParms)).length() > 0) {
            SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, null);
            SdrRequestBody sdrRB = new SdrRequestBody();
            ServiceAgentAttr.ESAsdrRequest sdrRequest = new ServiceAgentAttr.ESAsdrRequest();
            sdrRequest.requestType = "Authorization";
            sdrRequest.authorizationID = authorizationID;
            sdrRB.setUserAttachement(sdrRequest);
            sdrRB.addRequest(sdr);
            sdrRB.initializeMachineInformation();
            rc = ServiceAgentUtils.SdrSubmit(sdrRB, "ESA.web.authorize", "SaAuthReq");
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xmlResults not set");
        }
        return rc;
    }

    public static int ESASendEEDRequest(int RequestType2, String Mtms, String ProblemNumber, String Pmh, File EEDfile) {
        int nprob;
        int rc = 0;
        String xmlResults = "";
        String eedID = "";
        File myFile = EEDfile;
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] ESASendEEDRequest");
        switch (RequestType2) {
            case 3: {
                eedID = "PROBLEM";
                break;
            }
            case 4: {
                eedID = "DUMP";
                myFile = ServiceAgentUtils.processDump(myFile, 16000000);
                break;
            }
            case 5: {
                eedID = "ENDOFCALL";
                break;
            }
            default: {
                eedID = "UNKNOWN";
            }
        }
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] RequestType: " + eedID);
        String machType = Mtms.substring(0, 4);
        String machModel = Mtms.substring(5, 8);
        String machSerial = Mtms.substring(9, 16);
        String problemUUID = "";
        String tPmh = ESA_PMH_DEFAULT;
        String tProblemNumber = ESA_PROB_DEFAULT;
        if (ProblemNumber != null && ProblemNumber.length() > 0 && (nprob = Integer.parseInt(ProblemNumber)) > 0) {
            tProblemNumber = ProblemNumber;
            if (Pmh != null && Pmh.length() < 0) {
                try {
                    PIProblem theProblem;
                    ProblemManager pm = ProblemManager.getProblemManager();
                    List problems = pm.filter(new ProblemNumberFilter(nprob, new PASystem(machType, machModel, machSerial)));
                    if (problems.size() > 0 && (theProblem = (PIProblem)problems.get(0)) != null) {
                        problemUUID = theProblem.getUniqueKey();
                        if (theProblem.getPMH() != null && theProblem.getPMH().length() > 0) {
                            tPmh = theProblem.getPMH();
                        }
                    }
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] PM exception");
                    Trace.trace(TRACE_MASKF, e);
                }
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        String datetime = df.format(new Date(myFile.lastModified()));
        String FileName = machType + "." + machModel + "." + machSerial + ".problem." + tProblemNumber + ".pmh." + tPmh + myFile.getPath();
        FileName = FileName.replaceAll("/", ".");
        FileName = FileName.replaceAll("-", ".");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Settings for EED Request:");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                 FileName:" + FileName);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                 datetime:" + datetime);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                   length:" + myFile.length());
        HashMap<String, String> xmlParms = new HashMap<String, String>();
        xmlParms.put(ESA_KEY_EED_FILENAME, FileName);
        xmlParms.put(ESA_KEY_EED_TIMESTAMP, datetime);
        xmlParms.put(ESA_KEY_EED_LENGTH, String.valueOf(myFile.length()));
        xmlResults = ServiceAgentUtils.ESAProcessXMLRequest(RequestType2, xmlParms);
        if (xmlResults.length() > 0) {
            SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, myFile);
            SdrRequestBody sdrRB = new SdrRequestBody();
            ServiceAgentAttr.ESAsdrRequest sdrRequest = new ServiceAgentAttr.ESAsdrRequest();
            sdrRequest.requestType = "Dump_EED";
            sdrRequest.problemUUID = problemUUID;
            sdrRequest.sdrFiles = new HashMap();
            boolean remove = false;
            if (!EEDfile.getPath().equals(myFile.getPath())) {
                remove = true;
            }
            ServiceAgentAttr.ESAsdrFileInfo sdrFileInfo = new ServiceAgentAttr.ESAsdrFileInfo(myFile.getPath(), EEDfile.getPath(), remove);
            sdrRequest.sdrFiles.put("EED", sdrFileInfo);
            sdrRB.setUserAttachement(sdrRequest);
            sdrRB.setReportingMachineInfo(new RsfMachineInfo(machType, machModel, machSerial));
            sdrRB.addRequest(sdr);
            rc = ServiceAgentUtils.SdrSubmit(sdrRB, "ESA.xmit.service", "SaEEDReq");
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xmlResults not set");
        }
        return rc;
    }

    public static int ESASendEEDRequest(String requestType, String machType, String machModel, String machSerial, String ProblemNumber, String Pmh, File EEDfile, String problemUUID, String rsfMsgID) {
        int rc = 0;
        String xmlResults = "";
        String eedID = "";
        String Mtms = machType + "." + machModel + "." + machSerial;
        File myFile = EEDfile;
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] ESASendEEDRequest");
        if (Pmh != null) {
            if (Pmh.length() <= 0) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Setting PMH to default");
                Pmh = ESA_PMH_DEFAULT;
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Setting PMH to default");
            Pmh = ESA_PMH_DEFAULT;
        }
        if (EEDfile.getPath().startsWith("/dump/")) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got a dump file: " + myFile.getPath());
            myFile = ServiceAgentUtils.processDump(myFile, 16000000);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        String datetime = df.format(new Date(myFile.lastModified()));
        String FileName = Mtms + ".problem." + ProblemNumber + ".pmh." + Pmh + "." + requestType + myFile.getPath();
        FileName = FileName.replaceAll("/", ".");
        FileName = FileName.replaceAll("-", ".");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Settings for EED Request");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                 FileName:" + FileName);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                 datetime:" + datetime);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                   length:" + myFile.length());
        HashMap<String, String> xmlParms = new HashMap<String, String>();
        xmlParms.put(ESA_KEY_EED_FILENAME, FileName);
        xmlParms.put(ESA_KEY_EED_TIMESTAMP, datetime);
        xmlParms.put(ESA_KEY_EED_LENGTH, String.valueOf(myFile.length()));
        xmlResults = ServiceAgentUtils.ESAProcessXMLRequest(3, xmlParms);
        if (xmlResults.length() > 0) {
            SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, myFile);
            SdrRequestBody sdrRB = new SdrRequestBody();
            ServiceAgentAttr.ESAsdrRequest sdrRequest = new ServiceAgentAttr.ESAsdrRequest();
            sdrRequest.requestType = "Problem_EED";
            sdrRequest.problemUUID = problemUUID;
            sdrRequest.sdrFiles = new HashMap();
            boolean remove = false;
            if (!EEDfile.getPath().equals(myFile.getPath())) {
                remove = true;
            }
            ServiceAgentAttr.ESAsdrFileInfo sdrFileInfo = new ServiceAgentAttr.ESAsdrFileInfo(myFile.getPath(), EEDfile.getPath(), remove);
            sdrRequest.sdrFiles.put("EED", sdrFileInfo);
            sdrRB.setUserAttachement(sdrRequest);
            sdrRB.setReportingMachineInfo(new RsfMachineInfo(machType, machModel, machSerial));
            sdrRB.addRequest(sdr);
            rc = ServiceAgentUtils.SdrSubmit(sdrRB, rsfMsgID, "SaEEDReq");
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xmlResults not set");
        }
        return rc;
    }

    public static String ESAInventoryRequest(boolean sendit, String machType, String machModel, String machSerial, File Vpdfile) {
        int rc = 0;
        String xmlResults = "";
        String Mtms = machType + "." + machModel + "." + machSerial;
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] ESAInventoryRequest");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        String datetime = df.format(new Date(Vpdfile.lastModified()));
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Settings for Inventory Request");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                 datetime:" + datetime);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                   length:" + Vpdfile.length());
        HashMap<String, String> xmlParms = new HashMap<String, String>();
        xmlParms.put(ESA_KEY_EED_TIMESTAMP, datetime);
        xmlParms.put(ESA_KEY_EED_LENGTH, String.valueOf(Vpdfile.length()));
        xmlParms.put(ESA_KEY_VPD_NONDELTAREASON, "DELTA-PROCESSING-UNAVAILABLE");
        xmlResults = ServiceAgentUtils.ESAProcessXMLRequest(6, xmlParms);
        if (xmlResults.length() > 0) {
            if (sendit) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sendit");
                SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, Vpdfile);
                SdrRequestBody sdrRB = new SdrRequestBody();
                sdrRB.setReportingMachineInfo(new RsfMachineInfo(machType, machModel, machSerial));
                sdrRB.addRequest(sdr);
                rc = ServiceAgentUtils.SdrSubmit(sdrRB, "ESA.xmit.service", "SaVPDReq");
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xmlResults not set");
        }
        return xmlResults;
    }

    public static String ESAHealthCheckRequest(boolean sendit, String reportingSystem, String frequency, String status) {
        int rc = 0;
        String xmlResults = "";
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] ESAHealthCheckRequest");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        String datetime = df.format(new Date());
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Settings for HealthCheck Request");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]        datetime:" + datetime);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] reportingSystem:" + reportingSystem);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]       frequency:" + frequency);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]          status:" + status);
        HashMap<String, String> xmlParms = new HashMap<String, String>();
        xmlParms.put(ESA_KEY_EED_TIMESTAMP, datetime);
        xmlParms.put(ESA_KEY_HCHK_REPORTING_SYSTEM, reportingSystem);
        xmlParms.put(ESA_KEY_HCHK_FREQUENCY, frequency);
        xmlParms.put(ESA_KEY_HCHK_STATUS, status);
        xmlResults = ServiceAgentUtils.ESAProcessXMLRequest(7, xmlParms);
        if (xmlResults.length() > 0) {
            if (sendit) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sendit");
                SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, null);
                SdrRequestBody sdrRB = new SdrRequestBody();
                sdrRB.initializeMachineInformation();
                sdrRB.addRequest(sdr);
                rc = ServiceAgentUtils.SdrSubmit(sdrRB, "ESA.xmit.service", "SaHealthReq");
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xmlResults not set");
        }
        return xmlResults;
    }

    public static boolean getEmailSetting() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getEmailSetting");
        boolean EmailSetting = false;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            EmailSetting = cnp.EmailSetting;
        }
        return EmailSetting;
    }

    public static int setEmailSetting(boolean EmailSetting) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setEmailSetting");
        int rc = 3;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            cnp.EmailSetting = EmailSetting;
            rc = ServiceAgentUtils.writeCustomerNotifyPersistable(cnp);
        }
        return rc;
    }

    public static String getEmailSMTPServer() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getEmailSMTPServer");
        String EmailSMTPServer = "";
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            EmailSMTPServer = cnp.EmailSMTPServer;
        }
        return EmailSMTPServer;
    }

    public static int setEmailSMTPServer(String EmailSMTPServer) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setEmailSMTPServer");
        int rc = 3;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            cnp.EmailSMTPServer = EmailSMTPServer;
            rc = ServiceAgentUtils.writeCustomerNotifyPersistable(cnp);
        }
        return rc;
    }

    public static int getEmailPort() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getEmailPort");
        int EmailPort = 0;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            EmailPort = cnp.EmailPort;
        }
        return EmailPort;
    }

    public static int setEmailPort(int EmailPort) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setEmailPort");
        int rc = 3;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            cnp.EmailPort = EmailPort;
            rc = ServiceAgentUtils.writeCustomerNotifyPersistable(cnp);
        }
        return rc;
    }

    public static boolean getFtpOffLoadSetting() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpOffLoadSetting");
        boolean FtpOffLoadSetting = false;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpOffLoadSetting = ftp.FtpOffLoadSetting;
        }
        return FtpOffLoadSetting;
    }

    public static int setFtpOffLoadSetting(boolean FtpOffLoadSetting) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpOffLoadSetting");
        int rc = 9;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpOffLoadSetting = FtpOffLoadSetting;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpServerName() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpServerName");
        String FtpServerName = "";
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpServerName = ftp.FtpServerName;
        }
        return FtpServerName;
    }

    public static int setFtpServerName(String FtpServerName) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpServerName");
        int rc = 9;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpServerName = FtpServerName;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpServerDirectory() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpServerDirectory");
        String FtpServerDirectory = "";
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpServerDirectory = ftp.FtpServerDirectory;
        }
        return FtpServerDirectory;
    }

    public static int setFtpServerDirectory(String FtpServerDirectory) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpServerDirectory");
        int rc = 9;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpServerDirectory = FtpServerDirectory;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpServerUserName() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpServerUserName");
        String FtpServerUserName = "";
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpServerUserName = ftp.FtpServerUserName;
        }
        return FtpServerUserName;
    }

    public static int setFtpServerUserName(String FtpServerUserName) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpServerUserName");
        int rc = 9;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpServerUserName = FtpServerUserName;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpServerUserPassword() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpServerUserPassword");
        String FtpServerUserPassword = "";
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpServerUserPassword = ftp.FtpServerUserPassword;
        }
        return FtpServerUserPassword;
    }

    public static int setFtpServerUserPassword(String FtpServerUserPassword) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpServerUserPassword");
        int rc = 9;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpServerUserPassword = FtpServerUserPassword;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static int getFtpPort() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpPort");
        int FtpPort = 0;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpPort = ftp.FtpPort;
        }
        return FtpPort;
    }

    public static int setFtpPort(int FtpPort) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpPort");
        int rc = 9;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpPort = FtpPort;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpFirewallType() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpFirewallType");
        String FtpFirewallType = "";
        FtpFirewallPersistable ftp = ServiceAgentUtils.readFtpFirewallPersistable();
        if (ftp != null) {
            FtpFirewallType = ftp.FtpFirewallType;
        }
        return FtpFirewallType;
    }

    public static int setFtpFirewallType(String FtpFirewallType) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpFirewallType");
        int rc = 12;
        FtpFirewallPersistable ftp = ServiceAgentUtils.readFtpFirewallPersistable();
        if (ftp != null) {
            ftp.FtpFirewallType = FtpFirewallType;
            rc = ServiceAgentUtils.writeFtpFirewallPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpFirewallHostName() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpFirewallHostName");
        String FtpFirewallHostName = "";
        FtpFirewallPersistable ftp = ServiceAgentUtils.readFtpFirewallPersistable();
        if (ftp != null) {
            FtpFirewallHostName = ftp.FtpFirewallHostName;
        }
        return FtpFirewallHostName;
    }

    public static int setFtpFirewallHostName(String FtpFirewallHostName) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpFirewallHostName");
        int rc = 12;
        FtpFirewallPersistable ftp = ServiceAgentUtils.readFtpFirewallPersistable();
        if (ftp != null) {
            ftp.FtpFirewallHostName = FtpFirewallHostName;
            rc = ServiceAgentUtils.writeFtpFirewallPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpFirewallUserName() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpFirewallUserName");
        String FtpFirewallUserName = "";
        FtpFirewallPersistable ftp = ServiceAgentUtils.readFtpFirewallPersistable();
        if (ftp != null) {
            FtpFirewallUserName = ftp.FtpFirewallUserName;
        }
        return FtpFirewallUserName;
    }

    public static int setFtpFirewallUserName(String FtpFirewallUserName) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpFirewallUserName");
        int rc = 12;
        FtpFirewallPersistable ftp = ServiceAgentUtils.readFtpFirewallPersistable();
        if (ftp != null) {
            ftp.FtpFirewallUserName = FtpFirewallUserName;
            rc = ServiceAgentUtils.writeFtpFirewallPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpFirewallUserPassword() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpFirewallUserPassword");
        String FtpFirewallUserPassword = "";
        FtpFirewallPersistable ftp = ServiceAgentUtils.readFtpFirewallPersistable();
        if (ftp != null) {
            FtpFirewallUserPassword = ftp.FtpFirewallUserPassword;
        }
        return FtpFirewallUserPassword;
    }

    public static int setFtpFirewallUserPassword(String FtpFirewallUserPassword) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpFirewallUserPassword");
        int rc = 12;
        FtpFirewallPersistable ftp = ServiceAgentUtils.readFtpFirewallPersistable();
        if (ftp != null) {
            ftp.FtpFirewallUserPassword = FtpFirewallUserPassword;
            rc = ServiceAgentUtils.writeFtpFirewallPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpFirewallExclusionList() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpFirewallExclusionList");
        String FtpFirewallExclusionList = "";
        FtpFirewallPersistable ftp = ServiceAgentUtils.readFtpFirewallPersistable();
        if (ftp != null) {
            FtpFirewallExclusionList = ftp.FtpFirewallExclusionList;
        }
        return FtpFirewallExclusionList;
    }

    public static int setFtpFirewallExclusionList(String FtpFirewallExclusionList) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpFirewallExclusionList");
        int rc = 12;
        FtpFirewallPersistable ftp = ServiceAgentUtils.readFtpFirewallPersistable();
        if (ftp != null) {
            ftp.FtpFirewallExclusionList = FtpFirewallExclusionList;
            rc = ServiceAgentUtils.writeFtpFirewallPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpFirewallPassiveMode() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpFirewallPassiveMode");
        String FtpFirewallPassiveMode = "";
        FtpFirewallPersistable ftp = ServiceAgentUtils.readFtpFirewallPersistable();
        if (ftp != null) {
            FtpFirewallPassiveMode = ftp.FtpFirewallPassiveMode;
        }
        return FtpFirewallPassiveMode;
    }

    public static int setFtpFirewallPassiveMode(String FtpFirewallPassiveMode) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpFirewallPassiveMode");
        int rc = 12;
        FtpFirewallPersistable ftp = ServiceAgentUtils.readFtpFirewallPersistable();
        if (ftp != null) {
            ftp.FtpFirewallPassiveMode = FtpFirewallPassiveMode;
            rc = ServiceAgentUtils.writeFtpFirewallPersistable(ftp);
        }
        return rc;
    }

    public static int getFtpFirewallPort() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpFirewallPort");
        int FtpFirewallPort = 0;
        FtpFirewallPersistable ftp = ServiceAgentUtils.readFtpFirewallPersistable();
        if (ftp != null) {
            FtpFirewallPort = ftp.FtpFirewallPort;
        }
        return FtpFirewallPort;
    }

    public static int setFtpFirewallPort(int FtpFirewallPort) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpFirewallPort");
        int rc = 12;
        FtpFirewallPersistable ftp = ServiceAgentUtils.readFtpFirewallPersistable();
        if (ftp != null) {
            ftp.FtpFirewallPort = FtpFirewallPort;
            rc = ServiceAgentUtils.writeFtpFirewallPersistable(ftp);
        }
        return rc;
    }

    public static Map getEmailList() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getEmailList");
        Map EmailList = null;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            EmailList = cnp.EmailList;
        }
        return EmailList;
    }

    public static int addEmailEntry(String EmailAddress, String EmailSetting) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] addEmailEntry");
        int rc = 3;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            if (cnp.EmailList.containsKey(EmailAddress.toUpperCase())) {
                rc = 1;
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] EmailAddress[" + EmailAddress + "] already exists");
            } else {
                EmailValueObject Emailobj = new EmailValueObject();
                Emailobj.EmailAddress = EmailAddress;
                Emailobj.EmailSetting = EmailSetting;
                cnp.EmailList.put(EmailAddress.toUpperCase(), Emailobj);
                rc = ServiceAgentUtils.writeCustomerNotifyPersistable(cnp);
            }
        }
        return rc;
    }

    public static int updateEmailEntry(String EmailAddress, String newEmailAddress, String newEmailSetting) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] updateEmailEntry");
        int rc = 3;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]    EmailAddress[" + EmailAddress + "]");
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] newEmailAddress[" + newEmailAddress + "]");
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] newEmailSetting[" + newEmailSetting + "]");
            if (!EmailAddress.equals(newEmailAddress.toUpperCase()) && cnp.EmailList.containsKey(newEmailAddress.toUpperCase())) {
                rc = 1;
            } else if (null == cnp.EmailList.remove(EmailAddress.toUpperCase())) {
                rc = 2;
            } else {
                EmailValueObject Emailobj = new EmailValueObject();
                Emailobj.EmailAddress = newEmailAddress;
                Emailobj.EmailSetting = newEmailSetting;
                cnp.EmailList.put(newEmailAddress.toUpperCase(), Emailobj);
                rc = ServiceAgentUtils.writeCustomerNotifyPersistable(cnp);
            }
        }
        return rc;
    }

    public static int removeEmailEntry(String keyEmailAddress) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] removeEmailEntry");
        int rc = 3;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            rc = null == cnp.EmailList.remove(keyEmailAddress) ? 2 : ServiceAgentUtils.writeCustomerNotifyPersistable(cnp);
        }
        return rc;
    }

    public static int removeAllEmailEntries() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] removeAllEmailEntries");
        HashMap workEmailList = new HashMap(ServiceAgentUtils.getEmailList());
        int rc = 0;
        Iterator i = workEmailList.keySet().iterator();
        while (i.hasNext()) {
            rc = ServiceAgentUtils.removeEmailEntry((String)i.next());
            if (rc == 0) continue;
            return rc;
        }
        return 0;
    }

    public static int sendEmailMsgToAddresses(String[] emailAddresses, LocalizableText subject, LocalizableText message) {
        HashMap results = null;
        int rc = ServiceAgentUtils.sendEmailMsgToAddresses(emailAddresses, subject, message, results);
        return rc;
    }

    public static int sendEmailMsgToAddresses(String[] emailAddresses, LocalizableText subject, LocalizableText message, HashMap results) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] sendEmailMsgToAddresses");
        if (results == null) {
            results = new HashMap<String, String>();
        } else {
            results.clear();
        }
        byte block = 3;
        Log theLog = new Log(-86, -45, 0, "SaEmailNtfy", null, null, null, null);
        int rc = 0;
        String from = "ElectronicServiceAgent";
        NetworkInfo networkInfo = NetworkSettings.getNetworkSettings().getNetworkInfo();
        if (networkInfo != null && networkInfo.getComputerName().length() > 0 && networkInfo.getDomainName().length() > 0) {
            from = from + "@" + networkInfo.getComputerName() + "." + networkInfo.getDomainName();
        }
        String emailAddr = "";
        String EmailSMTPServer = ServiceAgentUtils.getEmailSMTPServer();
        int EmailPort = ServiceAgentUtils.getEmailPort();
        try {
            int i = 0;
            while (i < emailAddresses.length) {
                emailAddr = emailAddresses[i];
                Emailer email = new Emailer(EmailSMTPServer, EmailPort);
                email.send(emailAddr, from, subject.toString(), message.toString());
                results.put(emailAddr, "SaEmailSuc");
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Email sent to: " + emailAddresses[i]);
                ++i;
            }
        }
        catch (Exception e) {
            results.put(emailAddr, "SaEmailErr");
            block = (byte)(block + 1);
            theLog.add(block, e);
            rc = 3;
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] send exception: " + e);
        }
        theLog.add((byte)3, "SMTPServer[" + EmailSMTPServer + "] Port[" + Integer.toString(EmailPort) + "] subject[" + subject.toString(Locale.US) + "] message[" + message.toString(Locale.US));
        String res = "";
        Iterator j = results.entrySet().iterator();
        while (j.hasNext()) {
            Map.Entry e = j.next();
            res = res + (String)e.getKey() + "[" + (String)e.getValue() + "]";
        }
        block = (byte)(block + 1);
        theLog.add(block, res);
        theLog.log();
        return rc;
    }

    public static int ESASendEmailMsg(String calledhome, LocalizableText subject, LocalizableText message) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] ESASendEmailMsg (all addresses)");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] message.toString[" + message.toString() + "]");
        HashMap workEmailList = new HashMap(ServiceAgentUtils.getEmailList());
        ArrayList<String> emailList = new ArrayList<String>(workEmailList.size());
        Iterator i = workEmailList.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            EmailValueObject Emailobj = (EmailValueObject)e.getValue();
            if (Emailobj.EmailSetting.equals(ESA_ALL) || Emailobj.EmailSetting.equals(ESA_CALLHOMEONLY) && calledhome.equals("Y")) {
                emailList.add(Emailobj.EmailAddress);
                continue;
            }
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Email filtered: " + Emailobj.EmailAddress);
        }
        String[] addressArray = new String[emailList.size()];
        int i2 = 0;
        while (i2 < addressArray.length) {
            addressArray[i2] = (String)emailList.get(i2);
            ++i2;
        }
        HashMap results = new HashMap();
        return ServiceAgentUtils.sendEmailMsgToAddresses(addressArray, subject, message, results);
    }

    public static int getExecutionFrequency() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getExecutionFrequency");
        int ExecutionFrequency = 0;
        XMITServiceInfoPersistable cnp = ServiceAgentUtils.readXMITServiceInfoPersistable();
        if (cnp != null) {
            ExecutionFrequency = cnp.ExecutionFrequency;
        }
        return ExecutionFrequency;
    }

    public static int setExecutionFrequency(int ExecutionFrequency) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setExecutionFrequency");
        int rc = 6;
        XMITServiceInfoPersistable cnp = ServiceAgentUtils.readXMITServiceInfoPersistable();
        if (cnp != null) {
            cnp.ExecutionFrequency = ExecutionFrequency;
            rc = ServiceAgentUtils.writeXMITServiceInfoPersistable(cnp);
        }
        return rc;
    }

    public static long getExecutionTimeOfDay() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getExecutionTimeOfDay");
        long ExecutionTimeOfDay = 0L;
        XMITServiceInfoPersistable cnp = ServiceAgentUtils.readXMITServiceInfoPersistable();
        if (cnp != null) {
            ExecutionTimeOfDay = cnp.ExecutionTimeOfDay;
        }
        return ExecutionTimeOfDay;
    }

    public static int setExecutionTimeOfDay(long ExecutionTimeOfDay) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setExecutionTimeOfDay");
        int rc = 6;
        XMITServiceInfoPersistable cnp = ServiceAgentUtils.readXMITServiceInfoPersistable();
        if (cnp != null) {
            cnp.ExecutionTimeOfDay = ExecutionTimeOfDay;
            rc = ServiceAgentUtils.writeXMITServiceInfoPersistable(cnp);
        }
        return rc;
    }

    private static CustomerNotifyPersistable readCustomerNotifyPersistable() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] readCustomerNotifyPersistable");
        CustomerNotifyPersistable cnp = null;
        PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
        try {
            cnp = (CustomerNotifyPersistable)pMgr.read(ESA_CUSTOMER_NOTIFY_PERSIST);
            if (cnp == null) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] CustomerNotify persisted data not initialized");
                cnp = new CustomerNotifyPersistable();
                pMgr.write(ESA_CUSTOMER_NOTIFY_PERSIST, cnp);
            }
        }
        catch (PersistenceException exc) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] CustomerNotify persisted data exception" + exc);
        }
        return cnp;
    }

    private static int writeCustomerNotifyPersistable(CustomerNotifyPersistable cnp) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] writeCustomerNotifyPersistable");
        int rc = 0;
        if (cnp != null) {
            PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
            try {
                pMgr.write(ESA_CUSTOMER_NOTIFY_PERSIST, cnp);
            }
            catch (PersistenceException exc) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] CustomerNotify write persisted data exception" + exc);
                rc = 1;
            }
        } else {
            rc = 2;
        }
        return rc;
    }

    private static FtpOffLoadPersistable readFtpOffLoadPersistable() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] readFtpOffLoadPersistable");
        FtpOffLoadPersistable ftp = null;
        PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
        try {
            ftp = (FtpOffLoadPersistable)pMgr.read(ESA_FTP_OFFLOAD_PERSIST);
            if (ftp == null) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] FtpOffLoad persisted data not initialized");
                ftp = new FtpOffLoadPersistable();
                pMgr.write(ESA_FTP_OFFLOAD_PERSIST, ftp);
            }
        }
        catch (PersistenceException exc) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] FtpOffLoad persisted data exception" + exc);
        }
        return ftp;
    }

    private static int writeFtpOffLoadPersistable(FtpOffLoadPersistable ftp) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] writeFtpOffLoadPersistable");
        int rc = 0;
        if (ftp != null) {
            PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
            try {
                pMgr.write(ESA_FTP_OFFLOAD_PERSIST, ftp);
            }
            catch (PersistenceException exc) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] FtpOffLoad write persisted data exception" + exc);
                rc = 7;
            }
        } else {
            rc = 8;
        }
        return rc;
    }

    private static FtpFirewallPersistable readFtpFirewallPersistable() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] readFtpFirewallPersistable");
        FtpFirewallPersistable ftp = null;
        PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
        try {
            ftp = (FtpFirewallPersistable)pMgr.read(ESA_FTP_FIREWALL_PERSIST);
            if (ftp == null) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] FtpFirewall persisted data not initialized");
                ftp = new FtpFirewallPersistable();
                pMgr.write(ESA_FTP_FIREWALL_PERSIST, ftp);
            }
        }
        catch (PersistenceException exc) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] FtpFirewall persisted data exception" + exc);
        }
        return ftp;
    }

    private static int writeFtpFirewallPersistable(FtpFirewallPersistable ftp) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] writeFtpFirewallPersistable");
        int rc = 0;
        if (ftp != null) {
            PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
            try {
                pMgr.write(ESA_FTP_FIREWALL_PERSIST, ftp);
                rc = ServiceAgentUtils.updateFtpFirewallFile();
            }
            catch (PersistenceException exc) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] FtpFirewall write persisted data exception" + exc);
                rc = 10;
            }
        } else {
            rc = 11;
        }
        return rc;
    }

    public static int updateFtpFirewallFile() {
        int rc;
        block7: {
            Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] updateFtpFirewallFile");
            rc = 0;
            FtpFirewallPersistable ftp = ServiceAgentUtils.readFtpFirewallPersistable();
            if (ftp != null) {
                HashMap<String, String> firewallMap = new HashMap<String, String>();
                firewallMap.put(ESA_KEY_FtpFirewallType, ftp.FtpFirewallType);
                firewallMap.put(ESA_KEY_FtpFirewallHostName, ftp.FtpFirewallHostName);
                firewallMap.put(ESA_KEY_FtpFirewallUserName, ftp.FtpFirewallUserName);
                firewallMap.put(ESA_KEY_FtpFirewallUserPassword, ftp.FtpFirewallUserPassword);
                firewallMap.put(ESA_KEY_FtpFirewallPort, String.valueOf(ftp.FtpFirewallPort));
                firewallMap.put(ESA_KEY_FtpFirewallExclusionList, ftp.FtpFirewallExclusionList);
                firewallMap.put(ESA_KEY_FtpFirewallPassiveMode, ftp.FtpFirewallPassiveMode);
                try {
                    String filePath = BaseFileControl.getFilePath(ESA_PATH);
                    String tmpOutfile = filePath + "temp" + ESA_FTP_FIREWALL_FILE;
                    File outFile = new File(tmpOutfile);
                    FileWriter out = new FileWriter(outFile);
                    File inFile = new File(filePath + ESA_FTP_FIREWALL_FILE);
                    FileInputStream fis = new FileInputStream(inFile);
                    BufferedReader in = new BufferedReader(new InputStreamReader(fis));
                    String aLine = null;
                    while ((aLine = in.readLine()) != null) {
                        aLine = aLine.trim();
                        Iterator i = firewallMap.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry e = i.next();
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] firewallMap key[" + e.getKey() + "] value[" + e.getValue() + "]");
                            Pattern p = Pattern.compile((String)e.getKey());
                            Matcher m = p.matcher("");
                            m.reset(aLine);
                            aLine = m.replaceAll((String)e.getValue());
                        }
                        out.write(aLine + "\n");
                    }
                    out.close();
                    in.close();
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] moving file[" + tmpOutfile + "] to [" + ESA_FTP_FIREWALL_SAVE_FILE + "]");
                    Process pid = RootProcess.startProgram("mvFile " + tmpOutfile + " " + ESA_FTP_FIREWALL_SAVE_FILE);
                    if (pid != null) {
                        rc = pid.waitFor();
                        break block7;
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pid was null");
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Error processing firewall files");
                    Trace.trace(TRACE_MASKF, e);
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ftp was null");
            }
        }
        return rc;
    }

    private static XMITServiceInfoPersistable readXMITServiceInfoPersistable() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] readXMITServiceInfoPersistable");
        XMITServiceInfoPersistable cnp = null;
        PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
        try {
            cnp = (XMITServiceInfoPersistable)pMgr.read(ESA_XMIT_SERVICE_INFO_PERSIST);
            if (cnp == null) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] XMITServiceInfo persisted data not initialized");
                cnp = new XMITServiceInfoPersistable();
                cnp.ExecutionFrequency = 7;
                Date dt = new Date();
                cnp.ExecutionTimeOfDay = dt.getTime();
                pMgr.write(ESA_XMIT_SERVICE_INFO_PERSIST, cnp);
            }
        }
        catch (PersistenceException exc) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] XMITServiceInfo persisted data exception" + exc);
        }
        return cnp;
    }

    private static int writeXMITServiceInfoPersistable(XMITServiceInfoPersistable cnp) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] writeXMITServiceInfoPersistable");
        int rc = 0;
        if (cnp != null) {
            PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
            try {
                pMgr.write(ESA_XMIT_SERVICE_INFO_PERSIST, cnp);
            }
            catch (PersistenceException exc) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] XMITServiceInfo write persisted data exception" + exc);
                rc = 4;
            }
        } else {
            rc = 5;
        }
        return rc;
    }

    private static int SdrSubmit(SdrRequestBody sdrRB, String requestType, String eventType) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] SdrSubmit");
        int rc = 0;
        byte block = 3;
        Log theLog = new Log(-86, -45, 0, eventType, null, null, null, null);
        ArrayList aList = sdrRB.getRequestList();
        if (aList != null) {
            int i = 0;
            while (i < aList.size()) {
                SdrHttpRequest httpRequest = (SdrHttpRequest)aList.get(i);
                block = (byte)(block + 1);
                theLog.add(block, httpRequest.getXmlData());
                ++i;
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] aList wass null");
        }
        RemoteSupportFacility rsfImpl = RsfManager.getRsfManager().getConsoleRsf();
        RsfRequest request = rsfImpl.newRequestInstance(sdrRB, "com.ibm.hwmca.p.sa.ESARsfResultProcessor", new LocalizableText(ESAMSG, requestType));
        try {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] submit RsfRequest");
            request.submit();
            theLog.add((byte)3, request.getId());
            theLog.log();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] submit() exception " + e);
            rc = 1;
        }
        return rc;
    }

    public static String[] getMtmsList() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getMtmsList");
        int rc = 0;
        String[] MtmsArray = null;
        try {
            Process pid = RootProcess.startProgram("lsHSC -t0");
            if (pid != null) {
                InputStream ips = pid.getInputStream();
                rc = pid.waitFor();
                byte[] b = new byte[255];
                String machCat = "";
                String machType = "";
                String machModel = "";
                String machSerial = "";
                String buffer = "";
                if (ips != null) {
                    int bytesRead = ips.read(b);
                    while (bytesRead > 0) {
                        buffer = buffer + new String(b, 0, bytesRead, "US-ASCII");
                        bytesRead = ips.read(b);
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] buffer before replace: " + buffer);
                    if (buffer.length() > 1) {
                        buffer = buffer.replaceAll(";|:|\\.|_|-", " ").trim();
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] buffer after replace: " + buffer);
                        StringTokenizer st = new StringTokenizer(buffer, " ");
                        if (st.countTokens() % 4 == 0) {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] number of tokens: " + st.countTokens());
                            int reps = st.countTokens() / 4;
                            ArrayList<String> tmpList = new ArrayList<String>(reps);
                            int i = 0;
                            while (i < reps) {
                                machCat = st.nextToken();
                                machType = st.nextToken();
                                machModel = st.nextToken();
                                machSerial = st.nextToken();
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] machCat: " + machCat);
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] machType: " + machType);
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] machModel: " + machModel);
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] machSerial: " + machSerial);
                                if (!machType.equals("0")) {
                                    tmpList.add(machCat + " " + machType + " " + machModel + " " + machSerial);
                                } else {
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] invalid machine specified");
                                }
                                ++i;
                            }
                            if (tmpList.size() > 0) {
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] number of machines to process: " + tmpList.size());
                                MtmsArray = tmpList.toArray(new String[tmpList.size()]);
                                if (MtmsArray != null) {
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] MtmsArray.length: " + MtmsArray.length);
                                    int i2 = 0;
                                    while (i2 < MtmsArray.length) {
                                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] MtmsArray[" + i2 + "] = " + MtmsArray[i2]);
                                        ++i2;
                                    }
                                } else {
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] MtmsArray was null");
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] no machines to process");
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] invalid number of tokens: " + st.countTokens());
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] buffer was empty");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ips was null");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pid was null");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
        return MtmsArray;
    }

    public static int collectVpdFromMtms(String machType, String machModel, String machSerial) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] collectVpdFromMtms");
        int rc = 0;
        try {
            Process pid = RootProcess.startProgram("invSCOUT -v -m " + machType + "-" + machModel + " -s " + machSerial);
            rc = pid.waitFor();
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pid rc: " + rc);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
        return rc;
    }

    public static int XmitScheduled(String requestType) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] XmitScheduled");
        int rc = 0;
        rc = ServiceAgentUtils.XmitImmediate(requestType);
        return rc;
    }

    public static int XmitImmediate(String requestType) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] XmitImmediate");
        String eventType = "SaXmtImmReq";
        if (requestType.equals("Xmit_Scheduled")) {
            eventType = "SaXmtSchReq";
        }
        int rc = 0;
        Map[] mapArray = ServiceAgentUtils.getSystemInfo();
        if (mapArray != null) {
            int i = 0;
            while (i < mapArray.length) {
                Map tmpMap = mapArray[i];
                String name = (String)tmpMap.get("name");
                if (name != null) {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] working with system: " + name);
                    String type_model = (String)tmpMap.get("type_model");
                    String serial_num = (String)tmpMap.get("serial_num");
                    String state = (String)tmpMap.get("state");
                    String cod_mem_capable = (String)tmpMap.get("cod_mem_capable");
                    String cod_proc_capable = (String)tmpMap.get("cod_proc_capable");
                    String sp_version = (String)tmpMap.get("sp_version");
                    if (type_model != null && serial_num != null) {
                        String[] mtypemodel = type_model.split("-|_");
                        if (mtypemodel.length == 2) {
                            String fileName = "";
                            ServiceAgentAttr.ESAsdrRequest sdrRequest = new ServiceAgentAttr.ESAsdrRequest();
                            sdrRequest.requestType = requestType;
                            sdrRequest.sdrFiles = new HashMap();
                            SdrRequestBody sdrRB = new SdrRequestBody();
                            sdrRB.setReportingMachineInfo(new RsfMachineInfo(mtypemodel[0], mtypemodel[1], serial_num));
                            fileName = "/var/adm/invscout/" + mtypemodel[0] + "-" + mtypemodel[1] + "_" + serial_num + ".VPD.xml";
                            ServiceAgentAttr.ESAsdrFileInfo vpdFileInfo = new ServiceAgentAttr.ESAsdrFileInfo(fileName, fileName, false);
                            sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] VPD output file: " + fileName);
                            rc = ServiceAgentUtils.collectVpdFromMtms(mtypemodel[0], mtypemodel[1], serial_num);
                            File vpdFile = new File(fileName);
                            if (vpdFile != null) {
                                if (vpdFile.length() > 0L) {
                                    String xmlResults = ServiceAgentUtils.ESAInventoryRequest(false, mtypemodel[0], mtypemodel[1], serial_num, vpdFile);
                                    if (xmlResults.length() > 0) {
                                        SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, vpdFile);
                                        sdrRB.addRequest(sdr);
                                    } else {
                                        vpdFileInfo.fileName = fileName + "\nUnable to generate SDR request.";
                                        sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
                                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] VPD xmlResults.length was zero");
                                    }
                                } else {
                                    vpdFileInfo.fileName = fileName + "\nFile length was zero.";
                                    sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] vpdFile length was 0");
                                }
                            } else {
                                vpdFileInfo.fileName = fileName + "\nFile not found.";
                                sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] vpdFile was null");
                            }
                            fileName = "Heartbeat Information";
                            ServiceAgentAttr.ESAsdrFileInfo hBeatFileInfo = new ServiceAgentAttr.ESAsdrFileInfo(fileName, fileName, false);
                            sdrRequest.sdrFiles.put("Heartbeat", hBeatFileInfo);
                            String reportingSystem = ServiceAgentUtils.getLocalCredential();
                            if (reportingSystem != null && reportingSystem.length() > 0) {
                                String xmlResults = ServiceAgentUtils.ESAHealthCheckRequest(false, reportingSystem, Integer.toString(ServiceAgentUtils.getExecutionFrequency()), state);
                                if (xmlResults.length() > 0) {
                                    SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, null);
                                    sdrRB.addRequest(sdr);
                                } else {
                                    hBeatFileInfo.fileName = fileName + "\nUnable to generate SDR request.";
                                    sdrRequest.sdrFiles.put("Heartbeat", hBeatFileInfo);
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Heartbeat xmlResults.length was zero");
                                }
                            } else {
                                hBeatFileInfo.fileName = fileName + "\nUnable to generate local credential.";
                                sdrRequest.sdrFiles.put("Heartbeat", hBeatFileInfo);
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] localCredential not set");
                            }
                            if (sdrRB.getRequestList().size() > 0) {
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] issue SdrSubmit: " + requestType);
                                sdrRB.setUserAttachement(sdrRequest);
                                rc = ServiceAgentUtils.SdrSubmit(sdrRB, "ESA.xmit.service", eventType);
                            } else {
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] no data for SdrSubmit");
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] invalid machType machModel");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] type_model or serial_num were null");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] could not find key: name");
                }
                ++i;
            }
        }
        return rc;
    }

    public static int XmitVPD(String machType, String machModel, String machSerial) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] XmitEndOfCall");
        int rc = 0;
        String fileName = "";
        ServiceAgentAttr.ESAsdrRequest sdrRequest = new ServiceAgentAttr.ESAsdrRequest();
        sdrRequest.requestType = "Xmit_VPD";
        sdrRequest.sdrFiles = new HashMap();
        SdrRequestBody sdrRB = new SdrRequestBody();
        sdrRB.setReportingMachineInfo(new RsfMachineInfo(machType, machModel, machSerial));
        fileName = "/var/adm/invscout/" + machType + "-" + machModel + "_" + machSerial + ".VPD.xml";
        ServiceAgentAttr.ESAsdrFileInfo vpdFileInfo = new ServiceAgentAttr.ESAsdrFileInfo(fileName, fileName, false);
        sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] VPD output file: " + fileName);
        rc = ServiceAgentUtils.collectVpdFromMtms(machType, machModel, machSerial);
        File vpdFile = new File(fileName);
        if (vpdFile != null) {
            if (vpdFile.length() > 0L) {
                String xmlResults = ServiceAgentUtils.ESAInventoryRequest(false, machType, machModel, machSerial, vpdFile);
                if (xmlResults.length() > 0) {
                    SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, vpdFile);
                    sdrRB.addRequest(sdr);
                } else {
                    vpdFileInfo.fileName = fileName + "\nUnable to generate SDR request.";
                    sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
                }
            } else {
                vpdFileInfo.fileName = fileName + "\nFile length was zero.";
                sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] vpdFile length was 0");
            }
        } else {
            vpdFileInfo.fileName = fileName + "\nFile not found.";
            sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] vpdFile was null");
        }
        if (sdrRB.getRequestList().size() > 0) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] issue SdrSubmit: SaVPDReq");
            sdrRB.setUserAttachement(sdrRequest);
            rc = ServiceAgentUtils.SdrSubmit(sdrRB, "ESA.xmit.service", "SaVPDReq");
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] no data for SdrSubmit");
        }
        return rc;
    }

    public static Map[] getSystemInfo() {
        Map[] mapArray;
        block14: {
            Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getSystemInfo");
            int rc = 0;
            String[] sysArray = null;
            mapArray = null;
            try {
                Process pid = RootProcess.startProgram("lsSYSCFG -r sys");
                if (pid != null) {
                    InputStream ips = pid.getInputStream();
                    rc = pid.waitFor();
                    byte[] b = new byte[255];
                    String buffer = "";
                    if (ips != null) {
                        int bytesRead = ips.read(b);
                        while (bytesRead > 0) {
                            buffer = buffer + new String(b, 0, bytesRead, "US-ASCII");
                            bytesRead = ips.read(b);
                        }
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] lsSYSCFG buffer: " + buffer);
                        if (buffer.length() > 0) {
                            buffer = buffer.trim();
                            sysArray = (buffer = buffer.replace('\n', ';')).split(";");
                            if (sysArray != null) {
                                if (sysArray.length > 0) {
                                    if (sysArray[0].indexOf("name=") >= 0) {
                                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] number of elements: " + sysArray.length);
                                        ArrayList tmpArray = new ArrayList();
                                        int i = 0;
                                        while (i < sysArray.length) {
                                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sysArray[" + i + "] = " + sysArray[i]);
                                            StringTokenizer st = new StringTokenizer(sysArray[i], ",");
                                            int reps = st.countTokens();
                                            HashMap<String, String> tmpMap = new HashMap<String, String>();
                                            int j = 0;
                                            while (j < reps) {
                                                String[] tmpValue = st.nextToken().split("=");
                                                if (tmpValue != null && tmpValue.length == 2) {
                                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] key[" + tmpValue[0].trim() + "] value[" + tmpValue[1].trim() + "]");
                                                    tmpMap.put(tmpValue[0].trim(), tmpValue[1].trim());
                                                } else {
                                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] tmpValue not set properly");
                                                }
                                                ++j;
                                            }
                                            if (tmpMap.size() > 0) {
                                                tmpArray.add(tmpMap);
                                            }
                                            ++i;
                                        }
                                        if (tmpArray.size() <= 0) break block14;
                                        mapArray = tmpArray.toArray(new Map[tmpArray.size()]);
                                        break block14;
                                    }
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] data not set: " + sysArray[0]);
                                    break block14;
                                }
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sysArray.length was 0");
                                break block14;
                            }
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sysArray was null");
                            break block14;
                        }
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] buffer was empty");
                        break block14;
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ips was null");
                    break block14;
                }
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pid was null");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got an exception");
                Trace.trace(TRACE_MASKF, e);
            }
        }
        return mapArray;
    }

    public static String getCodInfo(String machType, String machModel, String machSerial, String parm) {
        String billInfo;
        block8: {
            Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getCodInfo");
            int rc = 0;
            billInfo = null;
            try {
                Process pid = RootProcess.startProgram("lsCOD -t bill -m " + machType + "-" + machModel + "*" + machSerial + " -r " + parm);
                if (pid != null) {
                    InputStream ips = pid.getInputStream();
                    rc = pid.waitFor();
                    byte[] b = new byte[255];
                    String buffer = "";
                    if (ips != null) {
                        int bytesRead = ips.read(b);
                        while (bytesRead > 0) {
                            buffer = buffer + new String(b, 0, bytesRead, "US-ASCII");
                            bytesRead = ips.read(b);
                        }
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] lsCOD buffer: " + buffer);
                        if (buffer.length() > 0) {
                            billInfo = buffer.trim();
                        } else {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] buffer was empty");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ips was null");
                    }
                    break block8;
                }
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pid was null");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got an exception");
                Trace.trace(TRACE_MASKF, e);
            }
        }
        return billInfo;
    }

    public static String getPartitionInfo(String machType, String machModel, String machSerial) {
        String partitionInfo;
        block8: {
            Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getCodInfo");
            int rc = 0;
            partitionInfo = null;
            try {
                Process pid = RootProcess.startProgram("lsPARTITION -c " + machType + "-" + machModel + "_" + machSerial);
                if (pid != null) {
                    InputStream ips = pid.getInputStream();
                    rc = pid.waitFor();
                    byte[] b = new byte[255];
                    String buffer = "";
                    if (ips != null) {
                        int bytesRead = ips.read(b);
                        while (bytesRead > 0) {
                            buffer = buffer + new String(b, 0, bytesRead, "US-ASCII");
                            bytesRead = ips.read(b);
                        }
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] lsPARTITION buffer: " + buffer);
                        if (buffer.length() > 0) {
                            partitionInfo = buffer.trim();
                        } else {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] buffer was empty");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ips was null");
                    }
                    break block8;
                }
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pid was null");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got an exception");
                Trace.trace(TRACE_MASKF, e);
            }
        }
        return partitionInfo;
    }

    public static String getCecCredential(String machType, String machModel, String machSerial) {
        String cecCredential;
        block9: {
            Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getCecCredential");
            boolean rc = false;
            cecCredential = null;
            CredentialStore cstore = PICredentials.getCredentialStore();
            String Mtms = machType + "-" + machModel + "*" + machSerial;
            if (cstore != null) {
                try {
                    SysInfo credential = CredentialUtils.getCredentials(Mtms, cstore);
                    if (credential == null) {
                        CredentialResult result = CredentialUtils.getNewCredentialsSynchronous(Mtms, cstore);
                        if (result != null) {
                            credential = result.getCredentials();
                            if (credential != null) {
                                cecCredential = credential.getMachineId();
                            } else {
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] credential was null");
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] result was null");
                        }
                        break block9;
                    }
                    cecCredential = credential.getMachineId();
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] getCredentials exception");
                    Trace.trace(TRACE_MASKF, CLASS_NAME + e);
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] cstore was null");
            }
        }
        return cecCredential;
    }

    public static String getLocalCredential() {
        String localCredential;
        block7: {
            Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getLocalCredential");
            boolean rc = false;
            localCredential = null;
            try {
                SysInfo credential = CredentialUtils.getLocalCredentials();
                if (credential == null) {
                    CredentialResult result = CredentialUtils.getNewLocalCredentialsSynchronous();
                    if (result != null) {
                        credential = result.getCredentials();
                        if (credential != null) {
                            localCredential = credential.getMachineId();
                        } else {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] credential was null");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] result was null");
                    }
                    break block7;
                }
                localCredential = credential.getMachineId();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] getLocalCredentials exception");
                Trace.trace(TRACE_MASKF, CLASS_NAME + e);
            }
        }
        return localCredential;
    }

    public static ServiceAgentAttr.ESAreportingMachInfo getReportingMachineInfo(PIProblem theProblem) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] -> getReportingMachineInfo");
        ServiceAgentAttr.ESAreportingMachInfo rep = new ServiceAgentAttr.ESAreportingMachInfo();
        if (theProblem.getReportingRemoteMachineSystem() != null) {
            rep.machType = theProblem.getReportingRemoteMachineSystem().getMachineType();
            rep.machModel = theProblem.getReportingRemoteMachineSystem().getMachineModel();
            rep.machSerial = theProblem.getReportingRemoteMachineSystem().getMachineSerial();
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] used ReportingRemoteMachineSystem for ReportingMachineInfo[" + rep.machType + rep.machModel + rep.machSerial + "]");
        } else if (theProblem.getFailingSystem() != null) {
            rep.machType = theProblem.getFailingSystem().getMachineType();
            rep.machModel = theProblem.getFailingSystem().getMachineModel();
            rep.machSerial = theProblem.getFailingSystem().getMachineSerial();
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] used FailingSystem for ReportingMachineInfo[" + rep.machType + rep.machModel + rep.machSerial + "]");
        } else if (theProblem.getPrimaryAnalyzingConsoleSystem() != null) {
            rep.machType = theProblem.getPrimaryAnalyzingConsoleSystem().getMachineType();
            rep.machModel = theProblem.getPrimaryAnalyzingConsoleSystem().getMachineModel();
            rep.machSerial = theProblem.getPrimaryAnalyzingConsoleSystem().getMachineSerial();
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] used PrimaryAnalyzingConsoleSystem for ReportingMachineInfo[" + rep.machType + rep.machModel + rep.machSerial + "]");
        }
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] <- getReportingMachineInfo");
        return rep;
    }

    public static File processDump(File theDump, int callHomeLimit) {
        File newFile = theDump;
        if (theDump.exists()) {
            if (theDump.length() > (long)callHomeLimit) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] theDump.length: " + theDump.length());
                int fileEntrySize = 0;
                boolean dumpHeaderSize = false;
                long totalDumpSize = 0L;
                long totalBytesCopied = 0L;
                TreeMap<sectionInfo, Integer> sMap = new TreeMap<sectionInfo, Integer>(PRIORITY_ORDER);
                try {
                    int count;
                    FileInputStream fis = new FileInputStream(theDump);
                    byte[] data = new byte[100];
                    int bytesRead = fis.read(data, 0, 64);
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] header: ");
                    Trace.trace(TRACE_MASKF, data);
                    fileEntrySize = ByteArray.extractU16(data, 8, false);
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] the end if the file directory is at: " + fileEntrySize);
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] read in the first section:");
                    bytesRead = fis.read(data, 0, 32);
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] section: " + data);
                    Trace.trace(TRACE_MASKF, data);
                    boolean atEndOfDirectory = false;
                    int sectionNumber = 1;
                    while (!atEndOfDirectory) {
                        sectionInfo si = new sectionInfo();
                        si.section = sectionNumber;
                        si.entrySize = ByteArray.extractU16(data, 8, false);
                        si.priority = ByteArray.extractU16(data, 10, false);
                        si.size = ServiceAgentUtils.extractU64(data, 24, false);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]         section: " + si.section);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]       entrySize: " + si.entrySize);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sectionPriority: " + si.priority);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]     sectionSize: " + si.size);
                        sMap.put(si, new Integer(sectionNumber));
                        ++sectionNumber;
                        long lastSectionFlag = ByteArray.extractU32(data, 16, false);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] last section data is " + lastSectionFlag);
                        if ((lastSectionFlag & 1L) > 0L) {
                            atEndOfDirectory = true;
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] last section is true");
                        } else {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] last section is false");
                        }
                        int bytesToRead = si.entrySize - 32;
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] bytes to read are " + bytesToRead);
                        int remainder = fis.read(data, 0, bytesToRead);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] the remainder data is:");
                        Trace.trace(TRACE_MASKF, data);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] read the next header:");
                        if (!atEndOfDirectory) {
                            fis.read(data, 0, 32);
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] the next header: " + data);
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] at the end don't read the next chunk");
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] we are at the end of the directory entires");
                    fis.close();
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] fileEntrySize: " + fileEntrySize);
                    int totalBytes = fileEntrySize;
                    Iterator i = sMap.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry e = i.next();
                        sectionInfo si = (sectionInfo)e.getKey();
                        Integer section = (Integer)e.getValue();
                        totalBytes += si.entrySize;
                    }
                    Iterator i2 = sMap.entrySet().iterator();
                    while (i2.hasNext()) {
                        Map.Entry e = i2.next();
                        sectionInfo si = (sectionInfo)e.getKey();
                        Integer section = (Integer)e.getValue();
                        if ((long)totalBytes + si.size <= (long)callHomeLimit) {
                            si.add = true;
                            totalBytes = (int)((long)totalBytes + si.size);
                        } else {
                            si.add = false;
                        }
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]       section: " + section);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]     entrySize: " + si.entrySize);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]      priority: " + si.priority);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]          size: " + si.size);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]           add: " + si.add);
                    }
                    fis = new FileInputStream(theDump);
                    int numBytes = 0;
                    byte[] cdata = new byte[4096];
                    String fileLocation = BaseFileControl.getFilePath(ESA_PATH) + theDump.getName();
                    FileOutputStream fos = new FileOutputStream(fileLocation);
                    BufferedOutputStream dest = new BufferedOutputStream(fos, cdata.length);
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] copying fileDirectorySection: " + fileEntrySize);
                    int bytesToCopy = fileEntrySize;
                    int wrkBytes = 0;
                    while (wrkBytes < bytesToCopy) {
                        numBytes = (bytesToCopy - wrkBytes) / cdata.length > 0 ? cdata.length : (bytesToCopy - wrkBytes) % cdata.length;
                        count = fis.read(cdata, 0, numBytes);
                        dest.write(cdata, 0, count);
                        wrkBytes += count;
                    }
                    totalBytesCopied += (long)fileEntrySize;
                    TreeMap<sectionInfo, Integer> sectionMap = new TreeMap<sectionInfo, Integer>(SECTION_ORDER);
                    sectionMap.putAll(sMap);
                    Iterator i3 = sectionMap.entrySet().iterator();
                    while (i3.hasNext()) {
                        Map.Entry e = i3.next();
                        sectionInfo si = (sectionInfo)e.getKey();
                        Integer section = (Integer)e.getValue();
                        count = fis.read(cdata, 0, si.entrySize);
                        if (!si.add) {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] zero size in section: " + section);
                            Arrays.fill(cdata, 24, 32, (byte)0);
                        }
                        dest.write(cdata, 0, count);
                        totalBytesCopied += (long)si.entrySize;
                    }
                    Iterator i4 = sectionMap.entrySet().iterator();
                    while (i4.hasNext()) {
                        Map.Entry e = i4.next();
                        sectionInfo si = (sectionInfo)e.getKey();
                        Integer section = (Integer)e.getValue();
                        if (!si.add) continue;
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] copying section: " + section);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]       entrySize: " + si.entrySize);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]        priority: " + si.priority);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]            size: " + si.size);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]             add: " + si.add);
                        bytesToCopy = (int)si.size;
                        int wrkBytes2 = 0;
                        while (wrkBytes2 < bytesToCopy) {
                            numBytes = (bytesToCopy - wrkBytes2) / cdata.length > 0 ? cdata.length : (bytesToCopy - wrkBytes2) % cdata.length;
                            count = fis.read(cdata, 0, numBytes);
                            dest.write(cdata, 0, count);
                            wrkBytes2 += count;
                        }
                        totalBytesCopied += si.size;
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] totalBytesCopied: " + totalBytesCopied);
                    dest.flush();
                    dest.close();
                    fos.close();
                    fis.close();
                    newFile = new File(fileLocation);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got exeception read the file");
                    Trace.trace(TRACE_MASKF, e);
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] file under limit: " + theDump.getPath());
                newFile = theDump;
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] file does not exist: " + theDump.getPath());
        }
        return newFile;
    }

    public static long extractU64(byte[] theArray, int offset, boolean swapBytes) {
        long theValue;
        if (swapBytes) {
            theValue = ((long)theArray[offset + 7] & 0xFFL) << 56;
            theValue = ((long)theArray[offset + 6] & 0xFFL) << 48;
            theValue = ((long)theArray[offset + 5] & 0xFFL) << 40;
            theValue = ((long)theArray[offset + 4] & 0xFFL) << 32;
            theValue = ((long)theArray[offset + 3] & 0xFFL) << 24;
            theValue += ((long)theArray[offset + 2] & 0xFFL) << 16;
            theValue += ((long)theArray[offset + 1] & 0xFFL) << 8;
            theValue += (long)theArray[offset] & 0xFFL;
        } else {
            theValue = ((long)theArray[offset] & 0xFFL) << 56;
            theValue += ((long)theArray[offset + 1] & 0xFFL) << 48;
            theValue += ((long)theArray[offset + 2] & 0xFFL) << 40;
            theValue += ((long)theArray[offset + 3] & 0xFFL) << 32;
            theValue += ((long)theArray[offset + 4] & 0xFFL) << 24;
            theValue += ((long)theArray[offset + 5] & 0xFFL) << 16;
            theValue += ((long)theArray[offset + 6] & 0xFFL) << 8;
            theValue += (long)theArray[offset + 7] & 0xFFL;
        }
        return theValue;
    }

    public static void main(String[] args) {
        System.out.println("procesing dumpfile: " + args[0]);
        File theDump = new File("/home/gregorm/dumps/" + args[0]);
        File file = ServiceAgentUtils.processDump(theDump, 16000000);
    }

    private static class sectionInfo {
        public int section;
        public int entrySize;
        public int priority;
        public long size;
        public boolean add;

        private sectionInfo() {
        }
    }

    public static class EmailValueObject
    implements Serializable {
        public String EmailAddress;
        public String EmailSetting;
    }
}

